package gov.va.vinci.dart.biz;

import java.util.List;
import java.util.Set;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestGroup extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		try {
			Group.findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);
		 
	}

	@Test
	public void testTwo() throws Exception {
		
		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		Group grp1 = groupList.get(0);
		Assert.assertNotNull(grp1);
		Assert.assertTrue(grp1.getId() > 0);

		Assert.assertNotNull(grp1.getShortName());
		Assert.assertTrue(grp1.getShortName().length() > 0);
		
		Group grp2 = Group.findById(grp1.getId());
		Assert.assertNotNull(grp2);
		Assert.assertEquals(grp2, grp1);
		
		Assert.assertNotNull(grp2.getShortName());
		Assert.assertTrue(grp2.getShortName().length() > 0);

	}

	@Test
	public void testThree() throws Exception {
		
		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		Group grp1 = groupList.get(0);
		Assert.assertNotNull(grp1);
		Assert.assertNotNull(grp1.getName());
		Assert.assertTrue(grp1.getName().length() > 0);
		
		Group grp2 = Group.findByName(grp1.getName());
		Assert.assertNotNull(grp2);
		Assert.assertEquals(grp2, grp1);
		
		try {
			Group.findByName(null);
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}

		try {
			Group.findByName("");
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}

		try {
			Group.findByName("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345679012345678901234657890");
			Assert.fail("Expected ObjectNotFoundException");
		}
		catch (ObjectNotFoundException e) {}

	}
	
	@Test
	public void testFour() throws Exception {

		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		// prime the person mock
		Person.findById(1004);
		
		Group testGroup = null;
		
		// find a group with members
		for (Group grp : groupList) {
			Assert.assertNotNull(grp);
			Assert.assertNotNull(grp.getMembers());
			
			if (grp.getMembers().size() > 0) {
				testGroup = grp;
				break;
			}
		}
		
		Assert.assertNotNull(testGroup);
		
		// do all the members of this group think they belong to the group?
		for (Person pers : testGroup.getMembers()) {
			Set<Group> groups = pers.getGroups();
			Assert.assertNotNull(groups);
			Assert.assertTrue(groups.size() > 0);
			Assert.assertTrue(groups.contains(testGroup));
		}
	}

	@Test
	public void testFive() throws Exception {

		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		// prime the person mock
		Person.findById(1004);
		
		Group testGroup = null;
		Role testRole = null;
		
		// find a group with members
		for (Group grp : groupList) {
			Assert.assertNotNull(grp);
			Assert.assertNotNull(grp.getMembers());
			
			if (grp.getSupportedRoles().size() > 0) {
				testRole = grp.getSupportedRoles().iterator().next();
				testGroup = grp;
				break;
			}
		}
		
		Assert.assertNotNull(testGroup);

		Assert.assertNotNull(testGroup.getSupportedRoles());
		Assert.assertTrue(testGroup.getSupportedRoles().contains(testRole));

	}

	@Test
	public void testSix() throws Exception {
		
		List<Group> groupList = Group.listAll();
		 
		Assert.assertNotNull(groupList);
		Assert.assertTrue(groupList.size() > 0);

		Group grp1 = groupList.get(0);
		Assert.assertNotNull(grp1);
		Assert.assertTrue(grp1.getId() > 0);

		Assert.assertNotNull(grp1.getShortName());
		Assert.assertTrue(grp1.getShortName().length() > 0);
		
		Group grp2 = groupList.get(1);
		Assert.assertNotNull(grp2);
		Assert.assertNotEquals(grp2, grp1);
		
		Assert.assertTrue(grp1.hashCode() > 0);
		Assert.assertTrue(grp2.hashCode() > 0);
		Assert.assertFalse(grp1.equals(null));
		Assert.assertFalse(grp1.equals("wrong class!"));
		Assert.assertFalse(grp1.equals(grp2));
	}
}
